function post_today_use()
{
    try
    {
        let current_date = new Date()
        current_date = current_date.toISOString().split('T')[0]
        fetch(`https://api.counterapi.dev/v1/btidu/uses_${current_date}/up`)
    }
    catch (error)
    {
        console.log(error)
    }
}

function post_today_unique_use()
{
    try
    {
        if (localStorage.getItem("today_unique_use") == null || localStorage.getItem("today_unique_use") != new Date().getDate())
        {
            let current_date = new Date()
            current_date = current_date.toISOString().split('T')[0]
            fetch(`https://api.counterapi.dev/v1/btidu/unique_uses_${current_date}/up`)
            localStorage.setItem("today_unique_use", new Date().getDate())
        }
        else
        {
            console.log("Todays unique use already posted.")
        }
    }
    catch (error)
    {
        console.log(error)
    }
}

function post_monthly_use()
{
    try
    {
        let monthly_users_date = new Date()
        let month_index = monthly_users_date.getMonth()
        fetch(`https://api.counterapi.dev/v1/btidu/uses_month_${month_index}/up`)
    }
    catch (error)
    {
        console.log(error)
    }
}

function post_total_use()
{
    try
    {
        fetch(`https://api.counterapi.dev/v1/btidu/uses_total/up`)
    }
    catch (error)
    {
        console.log(error)
    }
}

function post_using_stats()
{
    post_total_use();
    post_today_use();
    post_today_unique_use();
    post_monthly_use();

    console.log("Using stats posted.")
}

post_using_stats()