function update_bottombar_button()
{
    if (document.querySelector("#grades_bottombar_button")) { document.querySelector("#grades_bottombar_button").classList.add("selected") }
    else { setTimeout(update_bottombar_button, 10) }
}

function hide_old_ui()
{
    document.querySelector("#content").style.display = "none";
}

function redirect_to_grade_description_page(grade_value, grade_subject, grade_category, grade_date)
{
    let grade_description = document.querySelector("#fancybox-tmp p").innerText
    // let grade_date = document.querySelector("#fancybox-tmp").innerText.replace(grade_description, "")

    let target_location = `/students/${localStorage.getItem("student_id")}/grades`;
    target_location += `?grade_value=${grade_value}&grade_subject=${grade_subject}&grade_description=${grade_description}&grade_date=${grade_date}&grade_category=${grade_category}&view=grade_desc`
    target_location = target_location.replaceAll("+", "%2B")

    show_betteridu_splash()
    document.location.href = target_location
}

function redirect_to_short_grade_description_page(grade_value, grade_subject, grade_category, grade_date)
{
    let target_location = `/students/${localStorage.getItem("student_id")}/grades`;
    target_location += `?grade_value=${grade_value}&grade_subject=${grade_subject}&grade_description=${grade_value}&grade_date=${grade_date}&grade_category=${grade_category}&view=grade_desc`
    target_location = target_location.replaceAll("+", "%2B")

    console.log(target_location)

    show_betteridu_splash()
    document.location.href = target_location
}

function fetch_grade_description(grade_value, grade_subject, grade_category, grade_date)
{
    if (document.querySelector("#fancybox-tmp").children.length > 0)
    {
        redirect_to_grade_description_page(grade_value, grade_subject, grade_category, grade_date)
    }
    else { setTimeout(fetch_grade_description, 10) }
}

function create_grades_panel()
{
    let grades_panel = document.createElement("div")
    grades_panel.id = "betteridu_grades_panel"

    let grades_header = document.createElement("h1")

    if(en_language) { grades_header.innerHTML = "Your grades" }
    else { grades_header.innerHTML = "Twoje oceny" }
    
    grades_header.classList.add("grades_header")
    grades_panel.appendChild(grades_header)
    
    let all_subject_objects = document.querySelectorAll("#content > div > div > table.marks-table > tbody > tr")
    for(let x = 0; x < all_subject_objects.length; x++) {
        let subject_object = all_subject_objects[x]
        
        let subject_grades_panel = document.createElement("div")
        subject_grades_panel.classList.add("subject_grades_panel")
        
        let subject_name_header = document.createElement("p")
        subject_name_header.classList.add("subject_name")
        subject_name_header.innerHTML = subject_object.querySelector("td:nth-child(1)").innerText
        subject_grades_panel.appendChild(subject_name_header)
        
        let grades_values_container = document.createElement("div")
        grades_values_container.classList.add("grades_values_container")

        let all_subject_grade_objects = subject_object.querySelectorAll("td.averages-container .single-mark")
        for(let y = 0; y < all_subject_grade_objects.length; y++) {
            let grade_object = document.createElement("span")
            grade_object.classList.add("grade_value")
            grade_object.innerHTML = all_subject_grade_objects[y].querySelector(".value").innerText
            grade_object.style.backgroundColor = get_string_color(grade_object.innerHTML)

            if (all_subject_grade_objects[y].querySelector(".value").innerText.length > 9)
            {
                grade_object.innerHTML = grade_object.innerHTML.substring(0, 9) + "..."
            }

            let grade_category = "Grade"
            let grade_date = "unknown-date"

            try {
                grade_category = all_subject_grade_objects[y].querySelector(".desc").innerText
                grade_date = all_subject_grade_objects[y].querySelector(".date").innerText
                grade_category = grade_category.replace(grade_date, "")
            }
            catch(err) { console.error(err) }

            grade_object.onclick = function()
            {
                if (all_subject_grade_objects[y].querySelector(".value").querySelector("a") != null)
                {
                    all_subject_grade_objects[y].querySelector(".value").querySelector("a").click()
                    document.querySelector("#fancybox-tmp").style.display = "none"
                    fetch_grade_description(all_subject_grade_objects[y].querySelector(".value").innerText, subject_name_header.innerText, grade_category, grade_date)
                }
                else
                {
                    redirect_to_short_grade_description_page(all_subject_grade_objects[y].querySelector(".value").innerText, subject_name_header.innerText, grade_category, grade_date)
                }
            }

            grades_values_container.appendChild(grade_object)
        }
        
        subject_grades_panel.appendChild(grades_values_container)
        grades_panel.appendChild(subject_grades_panel)
    }
        
    document.body.appendChild(grades_panel)
}

function change_grades_page()
{
    load_style(APP_PATH + "styles/grades_style.css");

    hide_old_ui();
    create_grades_panel();

    update_bottombar_button();

    hide_splash_on_load();
}

function try_changing_grades_page()
{
    if (document.readyState === "complete" && SHOW_ORIGINAL_CONTENT) {
        change_grades_page()
        return true
    }

    setTimeout(try_changing_grades_page, 10)
    return false
}


try_changing_grades_page()