function update_bottombar_button()
{
    if (document.querySelector("#grades_bottombar_button")) { document.querySelector("#grades_bottombar_button").classList.add("selected") }
    else { setTimeout(update_bottombar_button, 10) }
}

function hide_old_ui()
{
    document.querySelector("#content").style.display = "none";
}

function create_grades_desc_panel()
{
    let grades_desc_panel = document.createElement("div")
    grades_desc_panel.classList.add("betteridu_grades_desc_panel")

    // Create header
    let grades_desc_header = document.createElement("h1")

    if (en_language) {grades_desc_header.innerHTML = "Grade description"}
    else {grades_desc_header.innerHTML = "Opis oceny"}

    grades_desc_panel.appendChild(grades_desc_header)

    // Create subheader
    let grades_desc_subheader = document.createElement("h2")

    if (en_language) {grades_desc_subheader.innerHTML = `from <span class='subject_name'>${URL_PARAMS.get("grade_subject")}</span>`}
    else {grades_desc_subheader.innerHTML = `z przedmiotu <span class='subject_name'>${URL_PARAMS.get("grade_subject")}</span>`}

    grades_desc_panel.appendChild(grades_desc_subheader)

    // Create grade paragragraph
    let grades_desc_paragraph = document.createElement("p")

    grades_desc_paragraph.classList.add("grades_desc_paragraph")
    grades_desc_paragraph.innerHTML = URL_PARAMS.get("grade_description")

    grades_desc_panel.appendChild(grades_desc_paragraph)

    // Create grade date
    let grades_desc_subinfo = document.createElement("p")

    grades_desc_subinfo.classList.add("grades_desc_subinfo")
    grades_desc_subinfo.innerHTML = URL_PARAMS.get("grade_category").replaceAll("(", "").replaceAll(")", "") + " " + URL_PARAMS.get("grade_date")

    grades_desc_panel.appendChild(grades_desc_subinfo)

    // Create back button
    let grades_desc_back_button = document.createElement("a")

    grades_desc_back_button.classList.add("betteridu_button")

    if (en_language) {grades_desc_back_button.innerHTML = "Back to grades"}
    else {grades_desc_back_button.innerHTML = "Wróć do ocen"}

    grades_desc_back_button.href = `/students/${localStorage.getItem("student_id")}/grades`;

    grades_desc_panel.appendChild(grades_desc_back_button)
    document.body.appendChild(grades_desc_panel)
}

function change_grade_desc_page()
{
    console.log("Changing grade desc page");

    load_style(APP_PATH + "styles/grades_style.css");

    hide_old_ui();
    create_grades_desc_panel();

    update_bottombar_button();
    hide_splash_on_load();
}

function try_changing_grades_page()
{
    if (document.readyState === "complete" && SHOW_ORIGINAL_CONTENT) {
        change_grade_desc_page()
        return true
    }

    setTimeout(try_changing_grades_page, 10)
    return false
}


try_changing_grades_page();

console.log("loaded");