function update_bottombar_button()
{
    if (document.querySelector("#homework_bottombar_button")) { document.querySelector("#homework_bottombar_button").classList.add("selected") }
    else { setTimeout(update_bottombar_button, 10) }
}

function hide_old_ui()
{
    document.querySelector("#content").style.display = "none";
}

function create_homework_panel()
{
    let homework_list_panel = document.createElement("div")
    homework_list_panel.id = "betteridu_homework_list_panel"
    
    let panel_header = document.createElement("h1")
    panel_header.classList.add("homework_header")

    if (en_language) {panel_header.innerHTML = "Your homework"}
    else {panel_header.innerHTML = "Zadania domowe"}

    homework_list_panel.appendChild(panel_header)

    let old_ui_homework_elements = document.querySelectorAll("#content > div > div > table > tbody > tr")
    for (let x = 1; x < old_ui_homework_elements.length; x++) {
        let homework_object = old_ui_homework_elements[x]
        console.log(homework_object)

        let homework_panel = document.createElement("div")
        homework_panel.classList.add("homework_panel")

        let homework_name = document.createElement("p")
        homework_name.classList.add("homework_name")
        homework_name.innerHTML = homework_object.querySelector("td:nth-child(1)").innerText

        let homework_deadline = document.createElement("p")
        homework_deadline.classList.add("homework_deadline")
        homework_deadline.innerHTML = "Aktywne do: " + homework_object.querySelector("td:nth-child(3)").innerText

        homework_panel.appendChild(homework_name)
        homework_panel.appendChild(homework_deadline)

        homework_panel.onclick = function() { homework_object.querySelector("td.actions > a").click() }

        homework_list_panel.appendChild(homework_panel)

    }

    if (old_ui_homework_elements.length == 1) {
        let no_homework_panel = document.createElement("div")
        no_homework_panel.classList.add("no_homework_panel")

        let no_homework_text = document.createElement("h1")
        no_homework_text.classList.add("no_homework_text")

        if (en_language) {no_homework_text.innerHTML = "You have no homework"}
        else {no_homework_text.innerHTML = "Nie masz żadnych zadań domowych."}

        no_homework_panel.appendChild(no_homework_text)
        homework_list_panel.appendChild(no_homework_panel)
    }

    document.body.appendChild(homework_list_panel)
}

function change_homework_page()
{
    load_style(APP_PATH + "styles/homework_object.css");

    hide_old_ui();
    create_homework_panel();

    update_bottombar_button();
    hide_splash_on_load();
}

function try_changing_homework_page()
{
    if (document.readyState === "complete" && SHOW_ORIGINAL_CONTENT) {
        change_homework_page()
        return true
    }

    setTimeout(try_changing_homework_page, 10)
    return false
}


try_changing_homework_page()