var need_to_check = true

function create_update_popup()
{
    if (document.location.href.endsWith("/lesson_plan")) {return;}
    if (document.querySelector("#betteridu_update_popup") != null) { document.querySelector("#betteridu_update_popup").remove(); }

    let popup_object = document.createElement("div");
    popup_object.id = "betteridu_update_popup";

    // create popup header

    let popup_header = document.createElement("p");
    
    if (en_language) {popup_header.innerHTML = "Newer version of BtIDU is available! <a target='_blank' href='https://betteridu.netlify.app'>ReInstall BtIDU</a>"}
    else {popup_header.innerHTML = "Nowsza wersja BtIDU jest już dostępna! <a target='_blank' href='https://betteridu.netlify.app'>Zainstaluj BtIDU ponownie</a>"}

    popup_object.appendChild(popup_header)

    document.body.insertBefore(popup_object, document.body.firstChild)
}

function show_update_popup()
{
    create_update_popup();
    need_to_check = false;
}

function create_version_info(latest_version_level)
{
    let version_info_object = document.createElement("p")
    version_info_object.id = "betteridu_version_info"
    version_info_object.innerHTML = `BtIDUvl${CURRENT_VERSION_LEVEL} l:vl${latest_version_level}`
    version_info_object.style.fontSize = "9px"
    version_info_object.style.textAlign = "center"
    version_info_object.style.opacity = "10%"
    document.body.appendChild(version_info_object)
}

function check_for_updates()
{
    if (!need_to_check) {return;}

    // fetch version level
    fetch(`https://api.counterapi.dev/v1/btidu/latest_version/`)
    .then(response => response.json())
    .then(data => {
        let latest_version_level = data.count
        if (latest_version_level > CURRENT_VERSION_LEVEL)
        {
            console.log("Newer version", latest_version_level, "available. Current version: ", CURRENT_VERSION_LEVEL)
            show_update_popup()
        }
        else
        {
            console.log("Current version ", CURRENT_VERSION_LEVEL, " is the latest. (", latest_version_level, ")")
        }

        if (document.location.href.split("/").length == 4 && URL_PARAMS.get("view") == null) {create_version_info(latest_version_level);}

        need_to_check = false;
    })
    .catch(error => console.error('Error checking for updates:', error));
}

setInterval(check_for_updates, 1000)