function hide_old_ui()
{
    document.querySelector("body > div.container").style.display = "none";
    document.querySelector("#footer").style.display = "none";
}

function create_welcome_text()
{
    let welcome_text = document.createElement("h1")

    if (en_language) {welcome_text.innerHTML = "Welcome, <span>" + localStorage.getItem("full_name") + "</span>!"}
    else { welcome_text.innerHTML = "Witaj, <span>" + localStorage.getItem("full_name") + "</span>!"}

    welcome_text.classList.add("betteridu_welcome_text")
    document.querySelector("#betteridu_app").appendChild(welcome_text)
}

function get_last_lesson_begin_time(lesson_plan, day)
{
    let last_lesson_begin_time_hours = 0
    let last_lesson_begin_time_minutes = 0

    for (let x = 0; x < lesson_plan[day - 1].length; x++) {
        let lesson = lesson_plan[day - 1][x]

        if (lesson.subject == "")
        {
            continue;
        }
        
        let lesson_begin_time_hours = parseInt(lesson.begin_time.split(":")[0])
        let lesson_begin_time_minutes = parseInt(lesson.begin_time.split(":")[1])

        if (lesson_begin_time_hours > last_lesson_begin_time_hours) {last_lesson_begin_time_hours = lesson_begin_time_hours}
        if (lesson_begin_time_hours == last_lesson_begin_time_hours && lesson_begin_time_minutes > last_lesson_begin_time_minutes) {last_lesson_begin_time_minutes = lesson_begin_time_minutes}
    }

    return [last_lesson_begin_time_hours, last_lesson_begin_time_minutes]
}

function is_time_later(time_1, time_2)
{
    let time_1_hours = time_1.split(":")[0]
    let time_1_minutes = time_1.split(":")[1]

    let time_2_hours = time_2.split(":")[0]
    let time_2_minutes = time_2.split(":")[1]

    if (time_1_hours > time_2_hours) {return true}
    if (time_1_hours == time_2_hours && time_1_minutes > time_2_minutes) {return true}

    return false
}

function get_day_name(day)
{
    if (en_language) {
        switch (day) {
            case 1: return "Monday"
            case 2: return "Tuesday"
            case 3: return "Wednesday"
            case 4: return "Thursday"
            case 5: return "Friday"
            case 6: return "Saturday"
            case 0: return "Sunday"
        }
    }
    else {
        switch (day) {
            case 1: return "Poniedziałek"
            case 2: return "Wtorek"
            case 3: return "Środa"
            case 4: return "Czwartek"
            case 5: return "Piątek"
            case 6: return "Sobota"
            case 0: return "Niedziela"
        }
    }
}

function create_nearest_lessons_panel()
{
    load_style(APP_PATH + "styles/lesson_plan.css")

    let nearest_lessons_panel = document.createElement("div")
    nearest_lessons_panel.classList.add("betteridu_nearest_lessons_panel")

    // Create header
    let panel_header = document.createElement("h2")
    panel_header.classList.add("panel_header")

    if (en_language) {panel_header.innerHTML = "Your nearest lessons"}
    else {panel_header.innerHTML = "Najbliższe lekcje"}

    nearest_lessons_panel.appendChild(panel_header)

    // Create content panel
    let panel_content = document.createElement("div")
    panel_content.classList.add("panel_content")

    let lesson_plan = JSON.parse(localStorage.getItem("lesson_plan"))

    let current_time = new Date()
    let showing_day = current_time.getDay()

    // we don`t want weekends
    if (showing_day == 0 || showing_day == 6) {showing_day = 1}

    // if we dont have any lessons today, show tomorrow
    if (parseInt(get_last_lesson_begin_time(lesson_plan, showing_day)[0]) < parseInt(current_time.getHours()) && showing_day == current_time.getDay())
    {
        console.log("Switched day, becouse the last lesson today begins at", get_last_lesson_begin_time(lesson_plan, showing_day)[0], " and its ", current_time.getHours())
        showing_day += 1
    }
    else
    {
        console.log("Didnt switch day, becouse the last lesson today begins at", get_last_lesson_begin_time(lesson_plan, showing_day)[0], " and its ", current_time.getHours())
        console.log("Showing day is", showing_day, "and current day is", current_time.getDay())
    }
    if (showing_day <= 0 || showing_day >= 6) {showing_day = 1}

    console.log(showing_day, current_time.getDay())

    // get nearest 3 lessons
    let nearest_lessons = []
    let x = 0
    while (nearest_lessons.length < 3 && x < lesson_plan[showing_day - 1].length) {
        let lesson = lesson_plan[showing_day - 1][x]
        
        console.log(lesson, x)
        
        if (parseInt(lesson.begin_time.split(":")[0]) < current_time.getHours() && showing_day == current_time.getDay()) {x += 1; continue;}
        if (lesson.subject != "") {nearest_lessons.push(lesson)}

        x += 1
    }

    console.log(nearest_lessons)
    console.log(current_time)

    // add lessons panels to content panel
    for (let x = 0; x < nearest_lessons.length; x++) {
        let lesson = nearest_lessons[x]

        let lesson_panel = document.createElement("div")
        lesson_panel.classList.add("lesson_panel")

        let lesson_index = document.createElement("p")
        lesson_index.classList.add("lesson_index")
        lesson_index.innerHTML = lesson.index + "."
        
        let lesson_subject = document.createElement("p")
        lesson_subject.classList.add("lesson_subject")
        lesson_subject.innerHTML = lesson.subject

        let lesson_subheader = document.createElement("p")
        lesson_subheader.classList.add("lesson_subheader")
        
        let lesson_time = document.createElement("span")
        lesson_time.classList.add("lesson_time")
        lesson_time.innerHTML = `${get_day_name(lesson.day + 1).substring(0, 3)} ${lesson.begin_time} - ${lesson.end_time}`

        let lesson_room = document.createElement("span")
        lesson_room.classList.add("lesson_room")
        lesson_room.innerHTML = lesson.room

        lesson_subheader.appendChild(lesson_time)
        lesson_subheader.appendChild(lesson_room)
        
        lesson_panel.appendChild(lesson_index)
        lesson_panel.appendChild(lesson_subject)
        lesson_panel.appendChild(lesson_subheader)

        panel_content.appendChild(lesson_panel)
    }

    // let open_lesson_plan_button = document.createElement("a")
    // open_lesson_plan_button.classList.add("betteridu_button")
    
    // if (en_language) {open_lesson_plan_button.innerHTML = "Open lesson plan"}
    // else {open_lesson_plan_button.innerHTML = "Otwórz plan lekcji"}

    // panel_content.appendChild(open_lesson_plan_button)

    nearest_lessons_panel.appendChild(panel_content)
    document.querySelector("#betteridu_app").appendChild(nearest_lessons_panel)
}

function create_homework_panel()
{
    load_style(APP_PATH + "styles/homework_object.css")

    let homework_panel = document.createElement("div")
    homework_panel.classList.add("betteridu_homework_panel")

    // create header
    let panel_header = document.createElement("h2")
    panel_header.classList.add("panel_header")

    if (en_language) {panel_header.innerHTML = "Your homework"}
    else {panel_header.innerHTML = "Zadania domowe"}
    homework_panel.appendChild(panel_header)

    // create content panel
    let panel_content = document.createElement("div")
    panel_content.classList.add("panel_content")

    let all_old_ui_homework_objects = document.querySelectorAll(".homework")
    for (let x = 0; x < all_old_ui_homework_objects.length; x++) {
        let homework_object = all_old_ui_homework_objects[x]

        console.log(homework_object)

        let homework_panel = document.createElement("div")
        homework_panel.classList.add("homework_panel")

        let homework_name = document.createElement("p")
        homework_name.classList.add("homework_name")
        homework_name.innerHTML = homework_object.querySelector(".name").innerText

        let homework_deadline = document.createElement("p")
        homework_deadline.classList.add("homework_deadline")
        homework_deadline.innerHTML = homework_object.querySelectorAll(".date")[1].innerText

        homework_panel.appendChild(homework_name)
        homework_panel.appendChild(homework_deadline)

        homework_panel.onclick = function() { homework_object.querySelector(".name > a").click() }

        panel_content.appendChild(homework_panel)
    }

    homework_panel.appendChild(panel_content)
    document.querySelector("#betteridu_app").appendChild(homework_panel)
}

function create_grades_panel()
{
    load_style(APP_PATH + "styles/grades_style.css")

    let grades_panel = document.createElement("div")
    grades_panel.classList.add("betteridu_grades_panel")

    // Create header
    let panel_header = document.createElement("h2")
    panel_header.classList.add("panel_header")

    if (en_language) {panel_header.innerHTML = "Your newest grades"}
    else {panel_header.innerHTML = "Najnowsze oceny"}
    grades_panel.appendChild(panel_header)

    // Create content panel
    let panel_content = document.createElement("div")
    panel_content.classList.add("panel_content")
    
    let old_ui_grades = document.querySelectorAll(".mark")
    for(let x = 0; x < old_ui_grades.length; x++) {
        let grade_object = old_ui_grades[x]

        let grade_panel = document.createElement("div")
        grade_panel.classList.add("grade_panel")
        
        let grade_header = document.createElement("div")
        grade_header.classList.add("grade_header")

        let grade_subject = document.createElement("span")
        grade_subject.classList.add("grade_subject")
        grade_subject.innerHTML = grade_object.querySelector(".subject").innerText

        let grade_header_break = document.createElement("br")

        let grade_subheader = document.createElement("span")
        grade_subheader.classList.add("grade_subheader")
        grade_subheader.innerHTML = grade_object.querySelector(".date").innerText

        grade_header.appendChild(grade_subject)
        grade_header.appendChild(grade_header_break)
        grade_header.appendChild(grade_subheader)

        let grade_value = document.createElement("p")
        grade_value.classList.add("grade_value")
        grade_value.innerHTML = grade_object.querySelector(".name").innerText

        if (grade_value.innerText.length > 7)
        {
            grade_value.innerText = grade_value.innerText.substring(0, 6) + "..."
        }

        grade_value.style.backgroundColor = get_string_color(grade_value.innerHTML)

        grade_value.onclick = function() { show_betteridu_splash(); document.location.href = `/students/${localStorage.getItem("student_id")}/grades`; }

        grade_panel.appendChild(grade_header)
        grade_panel.appendChild(grade_value)

        panel_content.appendChild(grade_panel)
    }

    grades_panel.appendChild(panel_content)
    document.querySelector("#betteridu_app").appendChild(grades_panel)
}

function create_exams_panel()
{
    load_style(APP_PATH + "styles/exams_style.css")

    let exams_panel = document.createElement("div")
    exams_panel.classList.add("betteridu_exams_panel")

    // Create header
    let panel_header = document.createElement("h2")
    panel_header.classList.add("panel_header")

    if (en_language) {panel_header.innerHTML = "Your exams"}
    else {panel_header.innerHTML = "Egzaminy"}
    exams_panel.appendChild(panel_header)

    // Create content panel
    let panel_content = document.createElement("div")
    panel_content.classList.add("panel_content")

    let old_ui_exams = document.querySelectorAll(".exam")
    for(let x = 0; x < old_ui_exams.length; x++) {
        let exam_object = old_ui_exams[x]

        let exam_panel = document.createElement("div")
        exam_panel.classList.add("exam_panel")

        let exam_icon = document.createElement("img")
        exam_icon.classList.add("exam_icon")
        exam_icon.classList.add("foreground_icon")
        exam_icon.src = APP_PATH + "src/exam.svg"

        let exam_subject = document.createElement("p")
        exam_subject.classList.add("exam_subject")
        exam_subject.innerHTML = exam_object.querySelector(".description").innerText

        let exam_subheader = document.createElement("span")
        exam_subheader.classList.add("exam_subheader")
        exam_subheader.innerHTML = exam_object.querySelector(".date").innerText + " • " + exam_object.querySelector(".subject").innerText

        exam_panel.appendChild(exam_icon)
        exam_panel.appendChild(exam_subject)
        exam_panel.appendChild(exam_subheader)

        panel_content.appendChild(exam_panel)
    }

    exams_panel.appendChild(panel_content)
    document.querySelector("#betteridu_app").appendChild(exams_panel)
}

function create_new_ui()
{
    var better_idu_app = document.createElement("div")
    better_idu_app.id = "betteridu_app"

    document.body.insertBefore(better_idu_app, document.querySelector("body > div.container"))

    create_welcome_text()

    create_nearest_lessons_panel()
    create_grades_panel()
    create_exams_panel()
    create_homework_panel()
}

function fetch_lesson_plan()
{
    let loaded_lesson_plan = [[], [], [], [], []]
    let old_ui_table = document.querySelector(".schedule > table")

    let old_ui_table_rows = old_ui_table.querySelectorAll("tbody > tr")
    for (let x = 0; x < old_ui_table_rows.length; x++) {
        let row = old_ui_table_rows[x]
        let row_cells = row.querySelectorAll("td")

        let full_time_string = row_cells[0].innerText

        full_time_string = full_time_string.replaceAll(" ", "")
        full_time_string = full_time_string.replaceAll(`(${x})`, "")
        full_time_string = full_time_string.replaceAll("\n", "")

        let begin_time = full_time_string.split("-")[0]
        let end_time = full_time_string.split("-")[1]

        for (let y = 1; y < row_cells.length; y++) {
            let cell = row_cells[y]
            let lesson_data = {
                "index" : x,
                "begin_time": begin_time,
                "end_time": end_time,
                "day" : y - 1,
                "subject": "",
                "room" : ""
            }

            if (cell.classList.contains("lesson")) {
                lesson_data.subject = cell.querySelector(".lesson-cell > .subject").innerText
                lesson_data.room = cell.querySelector(".lesson-cell > .location > a:nth-child(1)").innerText
            }

            loaded_lesson_plan[y - 1].push(lesson_data)
        }
    }

    console.log("Fetched lesson plan from this site.", loaded_lesson_plan)
    localStorage.setItem("lesson_plan", JSON.stringify(loaded_lesson_plan))
}

function fetch_data_from_old_ui()
{
    let full_name = document.querySelector("#login > strong")
    localStorage.setItem("full_name", full_name.textContent)

    let user_id = document.querySelector("#account-actions > #account > a").href.split("/")[4]
    localStorage.setItem("student_id", user_id)

    fetch_lesson_plan()
}

function update_bottombar_button()
{
    if (document.querySelector("#home_bottombar_button"))
    {
        document.querySelector("#home_bottombar_button").classList.add("selected")
    }
    else
    {
        setTimeout(update_bottombar_button, 10)
    }
}

function change_home_page()
{
    load_style(APP_PATH + "styles/home_page.css");

    remove_current_style()

    hide_old_ui()
    fetch_data_from_old_ui()

    create_new_ui()
    update_bottombar_button()

    hide_splash_on_load();
}

function try_changing_home_page()
{
    if (document.readyState === "complete" && SHOW_ORIGINAL_CONTENT) {
        change_home_page();
        return true
    }

    setTimeout(try_changing_home_page, 10)
    return false
}


try_changing_home_page()