var urls_to_fetch_at_all_messages_fetching = [
    "/internal_messages",
    "/informations",
    `/students/${localStorage.getItem("student_id")}/subject_announcements`,
]

function update_bottombar_button()
{
    if (document.querySelector("#messages_bottombar_button")) { document.querySelector("#messages_bottombar_button").classList.add("selected") }
    else { setTimeout(update_bottombar_button, 10) }
}

function hide_old_ui()
{
    document.querySelector("#content").style.display = "none";
}

function does_this_message_exist_in_message_list(message, message_list)
{
    for (let x = 0; x < message_list.length; x++)
    {
        if (message_list[x].name === message.name) { return true }
    }

    return false
}

function fetch_messages_from_old_ui()
{
    let current_messages_list = []
    if (localStorage.getItem("messages_inbox") !== null) { current_messages_list = JSON.parse(localStorage.getItem("messages_inbox")) }

    // look through the News of old ui
    let all_old_ui_news_elements = document.querySelectorAll(".news")
    for (let x = 0; x < all_old_ui_news_elements.length; x++)
    {
        let news_name = all_old_ui_news_elements[x].querySelector(".name").innerText
        let news_date = all_old_ui_news_elements[x].querySelector(".date").innerText
        let news_href_url = all_old_ui_news_elements[x].querySelector(".name > a").href

        let message_object = {
            type: "news",
            name: stylize_string(news_name),
            date: stylize_string(news_date),
            content: "",
            subject: "",
            author: "",
            href_url: stylize_string(news_href_url),
        }

        if (!does_this_message_exist_in_message_list(message_object, current_messages_list)) { current_messages_list.push(message_object) }
    }

    // look through announcements of old ui
    let all_old_ui_announcement_elements = document.querySelectorAll(".announcement")

    for (let x = 0; x < all_old_ui_announcement_elements.length; x++)
    {
        let announcement_name = all_old_ui_announcement_elements[x].querySelector(".name").innerText
        let announcement_date = all_old_ui_announcement_elements[x].querySelector(".date").innerText
        let announcement_subject = all_old_ui_announcement_elements[x].querySelector(".subject").innerText

        let announcement_href_url = all_old_ui_announcement_elements[x].querySelector(".name > a").href

        let message_object = {
            type: "announcement",
            name: stylize_string(announcement_name),
            date: stylize_string(announcement_date),
            content: "",
            subject: announcement_subject,
            author: "",
            href_url: announcement_href_url,
        }

        if (!does_this_message_exist_in_message_list(message_object, current_messages_list)) { current_messages_list.push(message_object) }
    }

    // look through messages of old ui
    let all_old_ui_message_elements = document.querySelectorAll(".message-table tr.odd,  .message-table tr.even")
    for (let x = 0; x < all_old_ui_message_elements.length; x++)
    {
        let message_name = all_old_ui_message_elements[x].querySelector("td:nth-child(3)").innerText
        let message_date = all_old_ui_message_elements[x].querySelector("td:nth-child(4)").innerText
        let message_author = all_old_ui_message_elements[x].querySelector(".user .name").innerText
        let message_href_url = all_old_ui_message_elements[x].querySelector("td:nth-child(3) > a").href

        let message_object = {
            type: "message",
            name: stylize_string(message_name),
            date: stylize_string(message_date),
            content: "",
            subject: "",
            author: message_author,
            href_url: message_href_url,
        }

        if (!does_this_message_exist_in_message_list(message_object, current_messages_list)) { current_messages_list.push(message_object) }
    }

    // look through top messages of old ui
    let all_old_ui_top_message_elements = document.querySelectorAll(".top-message-table tr.odd,  .top-message-table tr.even")
    for (let x = 0; x < all_old_ui_top_message_elements.length; x++)
    {
        let top_message_name = all_old_ui_top_message_elements[x].querySelector("td:nth-child(2)").innerText
        let top_message_date = all_old_ui_top_message_elements[x].querySelector("td:nth-child(3)").innerText
        let top_message_author = all_old_ui_top_message_elements[x].querySelector(".user .name").innerText
        let top_message_href_url = all_old_ui_top_message_elements[x].querySelector("td:nth-child(2) > a").href

        let message_object = {
            type: "message",
            name: stylize_string(top_message_name),
            date: stylize_string(top_message_date),
            content: "",
            subject: "",
            author: top_message_author,
            href_url: top_message_href_url,
        }

        if (!does_this_message_exist_in_message_list(message_object, current_messages_list)) { current_messages_list.push(message_object) }
    }

    // sort all messages by date, that is a string of "day month year, hour"

    current_messages_list.sort(function(a, b) {
        let date_a = get_date_from_polish_string(a.date);
        let date_b = get_date_from_polish_string(b.date);

        return date_b - date_a;
    });

    // update local storage
    localStorage.setItem("messages_inbox", JSON.stringify(current_messages_list))
    console.log(current_messages_list)
}

function start_all_messages_fetching()
{
    show_betteridu_splash()
    document.location.href = urls_to_fetch_at_all_messages_fetching[0] + "?view=messages_fetching&next_page=" + urls_to_fetch_at_all_messages_fetching[1] + "&current_index=0"
}

function create_messages_page()
{
    let messages_panel = document.createElement("div")
    messages_panel.id = "betteridu_messages_panel"

    let messages_panel_header = document.createElement("h1")
    messages_panel_header.classList.add("messages_panel_header")

    if (en_language) { messages_panel_header.innerHTML = "Messages" }
    else { messages_panel_header.innerHTML = "Wiadomości" }

    messages_panel.appendChild(messages_panel_header)

    // add messages list
    let messages_list = JSON.parse(localStorage.getItem("messages_inbox"))

    for (let x = 0; x < messages_list.length; x++)
    {
        let message_element = document.createElement("div")
        message_element.classList.add("message_element")

        let message_name = document.createElement("span")
        message_name.classList.add("message_name")
        message_name.innerHTML = messages_list[x].name

        let message_subheader = document.createElement("span")
        message_subheader.classList.add("message_subheader")
        message_subheader.innerHTML = messages_list[x].date

        let message_icon = document.createElement("img")
        message_icon.classList.add("message_icon")
        message_icon.classList.add("foreground_icon")

        if (messages_list[x].type == "news") { message_icon.src = APP_PATH + "src/news.svg" }
        if (messages_list[x].type == "announcement") { message_icon.src = APP_PATH + "src/announcement.svg" }``
        if (messages_list[x].type == "message") { message_icon.src = APP_PATH + "src/envelope.svg" }

        if (messages_list[x].href_url !== "")
        {
            message_element.addEventListener("click", function() {
                show_betteridu_splash()
                window.location.href = messages_list[x].href_url + "?view=message_display"
            })
        }
        
        message_element.appendChild(message_icon)
        message_element.appendChild(message_name)
        message_element.appendChild(message_subheader)

        messages_panel.appendChild(message_element)
    }

    // create load all messages button
    let load_all_messages_button = document.createElement("a")
    load_all_messages_button.classList.add("load_all_messages_button")
    load_all_messages_button.classList.add("betteridu_button")
    
    if (en_language) { load_all_messages_button.innerHTML = "Load all messages" }
    else { load_all_messages_button.innerHTML = "Wczytaj wszystkie wiadomości" }

    load_all_messages_button.addEventListener("click", start_all_messages_fetching)

    messages_panel.appendChild(load_all_messages_button)

    document.body.appendChild(messages_panel)
}

function redirect_to_next_fetching_page()
{
    let current_index = parseInt(URL_PARAMS.get("current_index")) + 1
    let next_page = URL_PARAMS.get("next_page")
    
    let next_page_arg = urls_to_fetch_at_all_messages_fetching[current_index + 1]
    
    if (current_index >= urls_to_fetch_at_all_messages_fetching.length) { 
        document.location.href = "/?view=messages"
        return
    }
    show_betteridu_splash()
    document.location.href = next_page + "?view=messages_fetching&next_page=" + next_page_arg + "&current_index=" + current_index
}

function change_messages_page()
{
    if (URL_PARAMS.get("view") == "messages_fetching")
    {
        hide_old_ui();
        fetch_messages_from_old_ui();
        redirect_to_next_fetching_page();

        setInterval(show_betteridu_splash, 100)
        return
    }

    console.log("Changing messages page");

    load_style(APP_PATH + "styles/messages_style.css");

    hide_old_ui();
    fetch_messages_from_old_ui();

    create_messages_page();

    update_bottombar_button();
    hide_splash_on_load();
}

function try_changing_messages_page()
{
    if (document.readyState === "complete" && SHOW_ORIGINAL_CONTENT) {
        change_messages_page()
        return true
    }

    setTimeout(try_changing_messages_page, 10)
    return false
}


try_changing_messages_page();

console.log("loaded");