var showing_day = 0

function get_last_lesson_begin_time(lesson_plan, day)
{
    let last_lesson_begin_time_hours = 0
    let last_lesson_begin_time_minutes = 0

    for (let x = 0; x < lesson_plan[day - 1].length; x++) {
        let lesson = lesson_plan[day - 1][x]

        if (lesson.subject == "")
        {
            continue;
        }
        
        let lesson_begin_time_hours = parseInt(lesson.begin_time.split(":")[0])
        let lesson_begin_time_minutes = parseInt(lesson.begin_time.split(":")[1])

        if (lesson_begin_time_hours > last_lesson_begin_time_hours) {last_lesson_begin_time_hours = lesson_begin_time_hours}
        if (lesson_begin_time_hours == last_lesson_begin_time_hours && lesson_begin_time_minutes > last_lesson_begin_time_minutes) {last_lesson_begin_time_minutes = lesson_begin_time_minutes}
    }

    return [last_lesson_begin_time_hours, last_lesson_begin_time_minutes]
}

function is_time_later(time_1, time_2)
{
    let time_1_hours = time_1.split(":")[0]
    let time_1_minutes = time_1.split(":")[1]

    let time_2_hours = time_2.split(":")[0]
    let time_2_minutes = time_2.split(":")[1]

    if (time_1_hours > time_2_hours) {return true}
    if (time_1_hours == time_2_hours && time_1_minutes > time_2_minutes) {return true}

    return false
}

function get_day_name(day)
{
    if (en_language) {
        switch (day) {
            case 1: return "Monday"
            case 2: return "Tuesday"
            case 3: return "Wednesday"
            case 4: return "Thursday"
            case 5: return "Friday"
            case 6: return "Saturday"
            case 0: return "Sunday"
        }
    }
    else {
        switch (day) {
            case 1: return "Poniedziałek"
            case 2: return "Wtorek"
            case 3: return "Środa"
            case 4: return "Czwartek"
            case 5: return "Piątek"
            case 6: return "Sobota"
            case 0: return "Niedziela"
        }
    }
}

function render_lesson_plan(day)
{
    let lesson_plan = JSON.parse(localStorage.getItem("lesson_plan"))
    let lessons_to_show = lesson_plan[day]

    if (document.querySelector(".betteridu_calendar") != null) {document.querySelector(".betteridu_calendar").remove()}

    let calendar_content = document.createElement("div")
    calendar_content.classList.add("betteridu_calendar")

    let last_lesson_end_time = [0, 0]

    console.log("rendering day ", lessons_to_show)

    for (let x = 0; x < lessons_to_show.length; x++)
    {
        let lesson = lessons_to_show[x]

        if (lesson.subject == "") {continue}

        let lesson_panel = document.createElement("div")
        lesson_panel.classList.add("lesson_panel")

        let lesson_index = document.createElement("p")
        lesson_index.classList.add("lesson_index")
        lesson_index.innerHTML = lesson.index + "."
        
        let lesson_subject = document.createElement("p")
        lesson_subject.classList.add("lesson_subject")
        lesson_subject.innerHTML = lesson.subject

        let lesson_subheader = document.createElement("p")
        lesson_subheader.classList.add("lesson_subheader")
        
        let lesson_time = document.createElement("span")
        lesson_time.classList.add("lesson_time")
        lesson_time.innerHTML = `${get_day_name(lesson.day + 1).substring(0, 3)} ${lesson.begin_time} - ${lesson.end_time}`

        if (lesson.end_time == undefined) {lesson_time.innerHTML = `${get_day_name(lesson.day + 1).substring(0, 3)} ${lesson.begin_time} - ???`}

        let lesson_room = document.createElement("span")
        lesson_room.classList.add("lesson_room")
        lesson_room.innerHTML = lesson.room.substring(0, 7)

        if (last_lesson_end_time[0] > 0 && lesson.end_time != undefined)
        {
            let pixels_to_add = 2
            let break_length = 0

            let current_lesson_begin_time = [parseInt(lesson.begin_time.split(":")[0]), parseInt(lesson.begin_time.split(":")[1])]

            break_length += (current_lesson_begin_time[0] - last_lesson_end_time[0]) * 60
            break_length += (current_lesson_begin_time[1] - last_lesson_end_time[1])

            pixels_to_add += break_length * 1.2

            lesson_panel.style.marginTop = `${pixels_to_add}px`
        }

        if (lesson.end_time != undefined) { last_lesson_end_time = [parseInt(lesson.end_time.split(":")[0]), parseInt(lesson.end_time.split(":")[1])] }
        else{ last_lesson_end_time = [0, 0] }

        lesson_subheader.appendChild(lesson_time)
        lesson_subheader.appendChild(lesson_room)
        
        lesson_panel.appendChild(lesson_index)
        lesson_panel.appendChild(lesson_subject)
        lesson_panel.appendChild(lesson_subheader)

        calendar_content.appendChild(lesson_panel)
    }

    document.body.appendChild(calendar_content)
}

function switch_calendar_day(day)
{
    console.log("Switching the day to ", day)

    let all_day_buttons = document.querySelectorAll(".day_button");
    Array.from(all_day_buttons).forEach(element => {element.classList.remove("active")});

    document.querySelector(`#day_${day + 1}_button`).classList.add("active");

    render_lesson_plan(day)
}

function create_top_calendar_bar()
{
    let top_calendar_bar = document.createElement("div");
    top_calendar_bar.classList.add("betteridu_top_calendar_bar");

    let days_box = document.createElement("div");
    days_box.classList.add("days_box");

    for (let i = 1; i < 6; i++)
    {
        let day_button = document.createElement("a");
        day_button.classList.add("day_button");
        day_button.id = `day_${i}_button`;
        day_button.innerHTML = get_day_name(i).substring(0, 3);

        day_button.addEventListener("click", function() {switch_calendar_day(i - 1);});

        days_box.appendChild(day_button);
    }

    top_calendar_bar.appendChild(days_box);

    document.querySelector("body").insertBefore(top_calendar_bar, document.querySelector("betteridu_navbar"))
}

function hide_old_ui()
{
    document.querySelector("body > div.double-column").style.display = "none";
}

function make_sure_if_lesson_plan_loaded()
{
    if (localStorage.getItem("lesson_plan") === null)
    {
        alert("Lesson plan has not been not loaded. Please, report this error to us.");
        document.location.href = "/";
    }
}

function set_starting_day()
{
    let date = new Date();
    let showing_day = date.getDay() - 1;

    // skip weekends
    if (showing_day <= -1) {showing_day = 0}
    if (showing_day >= 5) {showing_day = 0}

    switch_calendar_day(showing_day)
}

function update_bottombar_button()
{
    if (document.querySelector("#lesson_plan_bottombar_button"))
    {
        document.querySelector("#lesson_plan_bottombar_button").classList.add("selected")
    }
    else
    {
        setTimeout(update_bottombar_button, 10)
    }
}

function change_lesson_plan_page()
{
    load_style(APP_PATH + "styles/lesson_plan.css");

    make_sure_if_lesson_plan_loaded();
    hide_old_ui();

    create_top_calendar_bar();
    
    set_starting_day();
    update_bottombar_button();

    hide_splash_on_load();
}

function try_changing_lesson_plan_page()
{
    if (document.readyState === "complete" && SHOW_ORIGINAL_CONTENT) {
        change_lesson_plan_page()
        return true
    }

    setTimeout(try_changing_lesson_plan_page, 100)
    return false
}

try_changing_lesson_plan_page()