var LOAD_THIS = true

var SHOW_ORIGINAL_CONTENT = true

var COLOR_BACKGROUND = ""
var COLOR_BACKGROUND_LIGHT = ""
var COLOR_FOREGROUND_MAIN = ""
var COLOR_FOREGROUND_SECOND = ""
var COLOR_FOREGROUND_MAIN_LIGHT = ""

var COLOR_STR_LERP_1 = []
var COLOR_STR_LERP_2 = []

var FILTER_FOREGROUND = ""
var FILTER_FOREGROUND_SECOND = ""

var CLIENT_TYPE = "normal"

const POLISH_MONTH_NAMES = ["Styczeń", "Luty", "Marzec", "Kwiecień", "Maj", "Czerwiec", "Lipiec", "Sierpień", "Wrzesień", "Pazdziernik", "Listopad", "Grudzień"]

var dark_mode = true
var en_language = true
var logined_in = true

const URL_PARAMS = new URLSearchParams(window.location.search);

function set_dark_mode_colors()
{
    COLOR_BACKGROUND = "#090909"
    COLOR_BACKGROUND_LIGHT = "#000000"
    COLOR_FOREGROUND_MAIN = "#e0e0e0"
    COLOR_FOREGROUND_SECOND = "#a1e1ff"
    COLOR_FOREGROUND_MAIN_LIGHT = "#8d8d8d"

    COLOR_STR_LERP_1 = [255, 173, 173]
    COLOR_STR_LERP_2 = [173, 180, 255]

    FILTER_FOREGROUND = "invert(100%) sepia(0%) saturate(2417%) hue-rotate(50deg) brightness(108%) contrast(76%)"
    FILTER_FOREGROUND_SECOND = "invert(77%) sepia(39%) saturate(552%) hue-rotate(175deg) brightness(104%) contrast(103%)"

    console.log("Set dark mode colors.")
}

function set_light_mode_colors()
{
    COLOR_BACKGROUND = "#eff5f5"
    COLOR_BACKGROUND_LIGHT = "#ffffff"
    COLOR_FOREGROUND_MAIN = "#292929"
    COLOR_FOREGROUND_SECOND = "#1f94ce"
    COLOR_FOREGROUND_MAIN_LIGHT = "#8d8d8d"

    COLOR_STR_LERP_1 = [255, 173, 173]
    COLOR_STR_LERP_2 = [173, 180, 255]

    FILTER_FOREGROUND = "invert(10%) sepia(0%) saturate(0%) hue-rotate(149deg) brightness(104%) contrast(86%)"
    FILTER_FOREGROUND_SECOND = "invert(42%) sepia(92%) saturate(422%) hue-rotate(155deg) brightness(99%) contrast(98%)"

    console.log("Set light mode colors.")
}

function create_css_globals()
{
    try
    {
        let css_globals = document.createElement("style");
        css_globals.innerHTML = `
            @font-face {
                font-family: 'Clean';
                src: url('${APP_PATH}fonts/Comfortaa.ttf') format('truetype');
            }

            :root {
                --color_background: ${COLOR_BACKGROUND};
                --color_background_light: ${COLOR_BACKGROUND_LIGHT};
                --color_foreground_main: ${COLOR_FOREGROUND_MAIN};
                --color_foreground_second: ${COLOR_FOREGROUND_SECOND};
                --color_foreground_main_light: ${COLOR_FOREGROUND_MAIN_LIGHT};

                --filter_foreground: ${FILTER_FOREGROUND};
                --filter_foreground_second: ${FILTER_FOREGROUND_SECOND};
            }
        `;
        css_globals.setAttribute("name", "betteridu")

        document.head.appendChild(css_globals);
    }
    catch(error)
    {
        alert("Error creating css globals: "+ error.toString())
    }
}

function add_viewport_meta()
{
    try
    {
        let viewport_meta = document.createElement("meta");
        viewport_meta.name = "viewport";
        viewport_meta.content = "width=device-width, initial-scale=1.0";

        document.head.appendChild(viewport_meta);
    }
    catch(error)
    {
        alert("Error adding viewport meta: "+ error.toString())
    }
}

function update_colors()
{
    if (dark_mode) { set_dark_mode_colors(); }
    else { set_light_mode_colors(); }

    create_css_globals();
    add_viewport_meta();
}

function get_cookie(name)
{
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
}

function set_cookie(name, value, days)
{
    var expires = "";
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
        expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + (value || "")  + expires + "; path=/";
}

function load_script(url)
{
    if (CLIENT_TYPE == "extension") {return;}

    try
    {
        let script_injection_object = document.createElement("script");
        script_injection_object.src = url;
        console.log("Loading script ", url)
    
        document.head.appendChild(script_injection_object);
    }
    catch(error)
    {
        alert("Error loading " + url + ": "+ error.toString())
    }
}

function load_style(url)
{
    if (CLIENT_TYPE == "extension") {return;}

    try
    {
        let style_injection_object = document.createElement("link");
        style_injection_object.rel = "stylesheet";
        style_injection_object.href = url;
        style_injection_object.setAttribute("name", "betteridu");

        console.log("Loading style ", url)

        document.head.appendChild(style_injection_object);
    }
    catch(error)
    {
        alert("Error loading " + url + ": "+ error.toString())
    }
}

function unload_style(url)
{
    try
    {
        let style_injection_object = document.querySelector(`link[href="${url}"]`);
        style_injection_object.remove();
    }
    catch(error)
    {
        console.log("This style hasn't been loaded ", url, error)
    }
}

function remove_current_style()
{
    let current_styles = document.querySelectorAll("head > style, link")
    Array.from(current_styles).forEach(style => {
        if (style.getAttribute("name") != "betteridu")
        {
            console.log("Removing style ", style)
            style.remove()
        }
    })
}

function hide_splash_on_load()
{
    if (document.readyState === "complete") {
        hide_betteridu_splash()
        return;
    }

    document.addEventListener("readystatechange", function() {hide_splash_on_load()});

    setTimeout(hide_splash_on_load, 100);
}

function get_string_color(str)
{
    let string_int = 1

    for (let i = 0; i < str.length; i++) { string_int *= str.charCodeAt(i); string_int += str.charCodeAt(i);}

    string_int = string_int * string_int;

    let lerp_value = (string_int % 100) / 100.0
    let color = [0, 0, 0]

    // lerp between two LERP_COLORS
    for (let i = 0; i < 3; i++) { color[i] = COLOR_STR_LERP_1[i] * (1 - lerp_value) + COLOR_STR_LERP_2[i] * lerp_value; }

    color = color.map(Math.round)
    return `rgb(${color[0]}, ${color[1]}, ${color[2]})`;
}

function get_date_from_polish_string(polish_date_string)
{
    // ex. date "23 wrz 2024, 13:00"
    let date_day = parseInt(polish_date_string.split(" ")[0])
    let date_month_polish_name = polish_date_string.split(" ")[1]
    let date_year = parseInt(polish_date_string.split(", ")[0].split(" ")[2])

    let date_hour = parseInt(polish_date_string.split(", ")[1].split(":")[0])
    let date_minute = parseInt(polish_date_string.split(":")[1])

    let date_month = -1
    for (let i = 0; i < POLISH_MONTH_NAMES.length; i++)
    {
        let polish_name = POLISH_MONTH_NAMES[i].toLowerCase()
        if (polish_name.startsWith(date_month_polish_name.toLowerCase())) { date_month = i; break; }
    }

    let date = new Date(date_year, date_month, date_day, date_hour, date_minute);
    return date;
}

function stylize_string(str)
{
    str = str.replaceAll("\n", "")
    str = str.trim()

    return str
}

function main()
{
    console.log("BetterIDU init has just begun.");

    // make sure this script wont load twice
    if (APP_INIT_LOADED)
    {
        alert("BetterIDU has already been loaded.");
        return;
    }

    try
    {
        if (USING_EXTENSION) 
        {
            CLIENT_TYPE = "extension";
            console.log("Using extension");
        }
    }
    catch(error){
        console.log("Error while checking if using extension: " + error.toString())
    }

    APP_INIT_LOADED = true

    dark_mode = localStorage.getItem("theme") != "light";
    localStorage.setItem("theme", dark_mode ? "dark" : "light");

    en_language = get_cookie("locale") == "en";
    if (en_language) { set_cookie("locale", "en", 365); }
    else { set_cookie("locale", "pl", 365); }

    update_colors()
    load_style(APP_PATH + "styles/global_style.css");

    if (document.location.href.indexOf("idu.edu.pl") > -1) {
        // alert(`We are at ${document.location}. That is part of idu.edu.pl.`);
    }
    else {
        alert(`You cannot use BetterIDU for ${document.location}.`);
        console.log('Redirecting user to https://idu.edu.pl. The previous location was ${document.location}');
        document.location.href = "https://idu.edu.pl"
    }

    if (localStorage.getItem("switch_to_app_view_next_load") == "true")
    { localStorage.setItem("switch_to_app_view_next_load", false); localStorage.setItem("show_original_content", false)}

    remove_current_style();
    load_script(APP_PATH + "global_elements_adder.js");

    if (document.location.href.indexOf("idu.edu.pl/users/sign_in") > -1) { load_script(APP_PATH + "login_panel_style.js"); logined_in = false; }
    if (logined_in) { load_script(APP_PATH + "all_logined_in_style.js"); load_style(APP_PATH + "styles/old_ui_style.css"); }

    console.log(URL_PARAMS.get("view"))

    if (localStorage.getItem("show_original_content") != "true")
    {
        // load app overrides   
        if (document.location.href.split("/").length == 4 && URL_PARAMS.get("view") == null) { load_script(APP_PATH + "home_page.js"); }
        else if (document.location.href.endsWith("/lesson_plan")) { load_script(APP_PATH + "lesson_plan_page.js"); }
        else if (document.location.href.endsWith("/homeworks")) { load_script(APP_PATH + "homework_page.js"); }
        else if (document.location.href.endsWith("/grades")) { load_script(APP_PATH + "grades_page.js"); }

        else if (URL_PARAMS.get("view") == "grade_desc") { load_script(APP_PATH + "grade_desc_page.js"); }
        else if (URL_PARAMS.get("view") == "messages" || URL_PARAMS.get("view") == "messages_fetching") { load_script(APP_PATH + "messages_page.js"); }
        else if (URL_PARAMS.get("view") == "message_display") { load_script(APP_PATH + "message_display_page.js"); }

        else { hide_betteridu_splash(); }

        if (logined_in) { load_style(APP_PATH + "styles/old_ui_app_style.css");}
    }
    else {
        SHOW_ORIGINAL_CONTENT = false;
        localStorage.setItem("switch_to_app_view_next_load", true);
        hide_betteridu_splash(); 
    }
    
    // alert("BetterIDU Loaded.");
    console.log("BetterIDU has been loaded.");
}

if (LOAD_THIS)
{
    main()
}