function change_theme()
{
    if (localStorage.getItem("theme") == "light")
    {
        localStorage.setItem("theme", "dark")
    }
    else
    {
        localStorage.setItem("theme", "light")
    }

    document.location.reload()
}

function toggle_menu()
{
    if (document.querySelector("#betteridu_menu").style.display == "block")
    { 
        document.querySelector("#betteridu_menu").style.display = "none";
    }
    else
    {
        document.querySelector("#betteridu_menu").style.display = "block"
    }
}

function change_language()
{
    if (get_cookie("locale") == "pl") {set_cookie("locale", "en", 365)}
    else {set_cookie("locale", "pl", 365)}

    document.location.reload()
}

function add_global_menu()
{
    var global_menu = document.createElement("div")
    global_menu.id = "betteridu_menu"
    global_menu.style.display = "none"

    let change_language_button = document.createElement("a")

    if (en_language) {change_language_button.innerHTML = `<img src='${APP_PATH}src/translate.svg' class='foreground_icon' height='15px'><span>Change language</span`}
    else {change_language_button.innerHTML = `<img src='${APP_PATH}src/translate.svg' class='foreground_icon' height='15px'><span>Zmień język</span`}

    change_language_button.onclick = function() { change_language() }
    global_menu.appendChild(change_language_button)

    if (logined_in)
    {
        // add logout button

        let logout_button = document.createElement("a")

        if (en_language) {logout_button.innerHTML = `<img src='${APP_PATH}src/logout.svg' class='foreground_icon' height='15px'><span>Log out</span`}
        else {logout_button.innerHTML = `<img src='${APP_PATH}src/logout.svg' class='foreground_icon' height='15px'><span>Wyloguj się</span`}

        logout_button.addEventListener("click", function() 
        {  
            localStorage.clear()
            show_betteridu_splash(); document.location.href = "/users/sign_out"
        })
        
        // add show site version button
        let show_original_content_button = document.createElement("a")
        
        if (localStorage.getItem("show_original_content") == "true")
        {
            if (en_language) {show_original_content_button.innerHTML = `<img src='${APP_PATH}src/mobile.svg' class='foreground_icon' height='15px'><span>Show app version</span`}
            else {show_original_content_button.innerHTML = `<img src='${APP_PATH}src/mobile.svg' class='foreground_icon' height='15px'><span>Zmień na wersję mobilną</span`}
            
            show_original_content_button.onclick = function() { localStorage.setItem("show_original_content", false); document.location.reload(); }
        }
        else
        {
            if (en_language) {show_original_content_button.innerHTML = `<img src='${APP_PATH}src/desktop.svg' class='foreground_icon' height='15px'><span>Show original content</span`}
            else {show_original_content_button.innerHTML = `<img src='${APP_PATH}src/desktop.svg' class='foreground_icon' height='15px'><span>Pokaż orginalną treść</span`}
            
            show_original_content_button.onclick = function() { localStorage.setItem("show_original_content", true); document.location.reload(); }
        }

        // add report problem button

        let report_problem_button = document.createElement("a")

        if (en_language) {report_problem_button.innerHTML = `<img src='${APP_PATH}src/report.svg' class='foreground_icon' height='15px'><span>Report a bug/suggestion</span`}
        else {report_problem_button.innerHTML = `<img src='${APP_PATH}src/report.svg' class='foreground_icon' height='15px'><span>Zgłoś błąd/sugestię</span`}
        
        report_problem_button.href = "https://betteridu.netlify.app/report_a_bug"
        report_problem_button.target = "_blank"
        
        global_menu.appendChild(show_original_content_button)
        global_menu.appendChild(report_problem_button)

        // login button needs to be last
        global_menu.appendChild(logout_button)
    }
        

    // when clicked outside, hide menu
    window.addEventListener('click', function(e)
    { 
        if (!(document.getElementById('betteridu_menu').contains(e.target) || document.getElementById('betteridu_navbar').contains(e.target)))
        { 
            document.querySelector("#betteridu_menu").style.display = "none" 
        } 
    });

    document.body.insertBefore(global_menu, document.body.firstChild);
}

function add_global_navbar()
{
    var global_navbar = document.createElement("div")
    global_navbar.id = "betteridu_navbar"

    let hamburger_menu_button = document.createElement("a")
    hamburger_menu_button.id = "hamburger_menu_button"
    hamburger_menu_button.innerHTML = `<img src='${APP_PATH}src/settings.svg' class='foreground_icon' height='30px'>`
    hamburger_menu_button.onclick = function() {toggle_menu();}

    global_navbar.appendChild(hamburger_menu_button)

    let theme_change_button = document.createElement("a")
    theme_change_button.innerHTML = `<img class='foreground_icon' src='${APP_PATH}src/dark_mode.svg' height='30px'>`

    if (localStorage.getItem("theme") == "dark") 
    { 
        theme_change_button.innerHTML = `<img class='foreground_icon' src='${APP_PATH}src/light_mode.svg' height='30px'>`;
    }

    theme_change_button.onclick = function() { change_theme() }

    global_navbar.appendChild(theme_change_button)

    document.body.insertBefore(global_navbar, document.body.firstChild);
}

function add_global_bottombar()
{
    let global_bottombar = document.createElement("div")
    global_bottombar.id = "betteridu_bottombar"

    let author_footer = document.createElement("p")
    author_footer.id = "author_footer"
    author_footer.innerHTML = "Made with ❤️ by <a target='_blank' href='https://keewinek.netlify.app'>keewinek</a>."
    global_bottombar.appendChild(author_footer)

    document.body.appendChild(global_bottombar);
}

function add_global_bottombar_nav()
{
    let global_bottombar = document.querySelector("#betteridu_bottombar")

    if (localStorage.getItem("student_id") == null)
    {
        console.log("Waiting for student id...")

        setTimeout(add_global_bottombar_nav, 100)
        return
    }

    // create home button
    let home_button = document.createElement("a")
    home_button.innerHTML = `<img src='${APP_PATH}src/home.svg' class='foreground_icon' height='25px'>`
    home_button.onclick = function() { show_betteridu_splash(); document.location.href = "/" }

    home_button.classList.add("bottombar_button")
    home_button.id = "home_bottombar_button"

    // create lesson plan button
    let lesson_plan_button = document.createElement("a")
    lesson_plan_button.innerHTML = `<img src='${APP_PATH}src/lesson_plan.svg' class='foreground_icon' height='25px'>`
    lesson_plan_button.onclick = function() { show_betteridu_splash(); document.location.href = `/students/${localStorage.getItem("student_id")}/lesson_plan` }

    lesson_plan_button.classList.add("bottombar_button")
    lesson_plan_button.id = "lesson_plan_bottombar_button"

    // create homework button
    let homework_button = document.createElement("a")
    homework_button.innerHTML = `<img src='${APP_PATH}src/homework.svg' class='foreground_icon' height='25px'>`
    homework_button.onclick = function() { show_betteridu_splash(); document.location.href = `/students/${localStorage.getItem("student_id")}/homeworks` }

    homework_button.classList.add("bottombar_button")
    homework_button.id = "homework_bottombar_button"

    // create grades button
    let grades_button = document.createElement("a")
    grades_button.innerHTML = `<img src='${APP_PATH}src/grades.svg' class='foreground_icon' height='25px'>`
    grades_button.onclick = function() { show_betteridu_splash(); document.location.href = `/students/${localStorage.getItem("student_id")}/grades` }

    grades_button.classList.add("bottombar_button")
    grades_button.id = "grades_bottombar_button"

    // create messages button
    let messages_button = document.createElement("a")
    messages_button.innerHTML = `<img src='${APP_PATH}src/messages.svg' class='foreground_icon' height='25px'>`
    messages_button.onclick = function() { show_betteridu_splash(); document.location.href = "/?view=messages" }

    messages_button.classList.add("bottombar_button")
    messages_button.id = "messages_bottombar_button"
    
    global_bottombar.appendChild(home_button)
    global_bottombar.appendChild(homework_button)
    global_bottombar.appendChild(lesson_plan_button)
    global_bottombar.appendChild(grades_button)
    global_bottombar.appendChild(messages_button)

}

function add_global_elements()
{
    load_style(APP_PATH + "styles/global_elements_navbar.css")
    load_style(APP_PATH + "styles/global_elements_hamburger_menu.css")
    load_style(APP_PATH + "styles/global_elements_bottombar.css")

    add_global_menu()
    add_global_navbar()

    add_global_bottombar()

    if (logined_in) { add_global_bottombar_nav() }
}

function try_adding_elements()
{
    if (document.readyState === "complete") {
        add_global_elements()
        return true
    }

    setTimeout(try_adding_elements, 10)
    return false
}

try_adding_elements()