var last_tab_open = 0;

function open_idu_if_closed()
{
    // check chrome local storage
    chrome.storage.local.get("force_open", function (result) {
        if (result.force_open) {
            chrome.tabs.query({}, function(tabs) { 
                // console.log("Checking if IDU tab exists", tabs);
        
                if (tabs.length > 0) {
                    let idu_tab_exists = false;
        
                    for (let i = 0; i < tabs.length; i++) {
                        try {
                            if (tabs[i].url.includes("idu.edu.pl") || tabs[i].pendingUrl.includes("idu.edu.pl")) {
                                idu_tab_exists = true;
                                break;
                            }
                        }
                        catch (e) {  }
                    }
        
                    if (!idu_tab_exists && Date.now() - last_tab_open > 1000) {
                        console.log("Opening IDU tab");
        
                        last_tab_open = Date.now();
                        chrome.tabs.create({ url: "https://idu.edu.pl/" });
                    }
                    else
                    {
                        // console.log("IDU tab already exists");
                    }
                }
            });
        }
    });

    
}

setInterval(open_idu_if_closed, 100);
chrome.runtime.onInstalled.addListener(function() {
    console.log("Extension installed");
    chrome.storage.local.set({ "force_open": true });
    open_idu_if_closed();
});

open_idu_if_closed();
console.log("Background worker started.");