function set_input_fields_styles()
{
    document.querySelector("#new_user > div:nth-child(3)").classList.add("better_input_field")
    document.querySelector("#new_user > div:nth-child(5)").classList.add("better_input_field")
}

function add_sub_logging_header()
{
    let sub_logging_header = document.createElement("h2")
    if (en_language) {sub_logging_header.innerText = "to the idu.edu.pl system."}
    else {sub_logging_header.innerText = "do systemu idu.edu.pl."}
    document.querySelector("#new_user > div:nth-child(2)").appendChild(sub_logging_header)
}

function change_top_logo()
{
    if (localStorage.getItem("theme") == "dark") {document.querySelector("#logo > img").src = APP_PATH + "src/brand/small_text_logo_white_beta.png";}
    else {document.querySelector("#logo > img").src = APP_PATH + "src/brand/small_text_logo_black_beta.png";}
}

function update_style()
{
    load_style(APP_PATH + "styles/input_fields.css")
    load_style(APP_PATH + "styles/login_panel.css")

    document.body.classList.add("login_page")
    
    remove_current_style()
    
    add_sub_logging_header()
    set_input_fields_styles()

    change_top_logo()
}

function encrytp_token(login, pass)
{
    let token = login + ":" + pass
    token = btoa(token)

    return token
}

function decrypt_token(token)
{
    let decoded_token = atob(token)
    let login = decoded_token.split(":")[0]
    let pass = decoded_token.split(":")[1]

    return [login, pass]
}

function update_token()
{
    localStorage.removeItem("token")

    let user_login = document.querySelector("#user_login").value
    let user_password = document.querySelector("#user_password").value

    if (user_login == "" || user_password == "") {return false;}

    let token = encrytp_token(user_login, user_password)
    localStorage.setItem("token", token)

    return true
}

function auto_login()
{
    let current_time = new Date().getTime() / 1000

    document.querySelector("#user_remember_me").click() // remember me checkbox

    if (localStorage.getItem("token") != null)
    {
        if (localStorage.getItem("last_auto_login") != null && current_time - localStorage.getItem("last_auto_login") < 3)
        {
            console.log("Auto login has been canceled, because last auto_login was " + (current_time - localStorage.getItem("last_auto_login")) + "s ago.")
        }
        else
        {
            try
            {                
                login_data = decrypt_token(localStorage.getItem("token"))
        
                document.querySelector("#user_login").value = login_data[0]
                document.querySelector("#user_password").value = login_data[1]
        
                document.querySelector("#new_user > div.actions > input[type=submit]").click()
        
                localStorage.setItem("last_auto_login", current_time)

                show_betteridu_splash()
                return;
            }
            catch (e)
            {
                alert(`BetterIDU: Error while auto logging in. Please try again. Error: ${e}`)
            }
        }
    }
    else
    {
        setInterval(update_token, 100)
    }
    
    hide_splash_on_load();

    document.querySelector("#new_user > div.actions > input[type=submit]").addEventListener("click", function() {
        update_token();
        show_betteridu_splash();
    })

    document.querySelector("#user_login").addEventListener("input", update_token)
    document.querySelector("#user_password").addEventListener("input", update_token)
}

function try_updating()
{
    if (document.readyState === "complete") {
        update_style()
        setTimeout(auto_login, 100);

        return true
    }

    setTimeout(try_updating, 100)
    return false
}

try_updating()