var APP_PATH = "https://betteridu.netlify.app/extension/app/"
var APP_INIT_LOADED = false
var USING_EXTENSION = true

function update_betteridu_splash_size()
{
    if (document.querySelector(".betteridu_splash") == null) {return;}

    let screen_width = window.outerWidth;
    let screen_height = window.outerHeight;

    let splash_object = document.querySelector(".betteridu_splash");
    let splash_image = document.querySelector(".betteridu_splash > img");

    splash_object.style.width = `${screen_width}px`;
    splash_object.style.height = `${screen_height}px`;

    splash_image.style.width = `${screen_width / 2}px`;
}

function create_betteridu_splash()
{
    var all_background_splash = document.createElement("div");
    all_background_splash.className = "betteridu_splash_all_background";
    all_background_splash.style.position = "fixed";
    all_background_splash.style.top = "0";
    all_background_splash.style.left = "0";
    all_background_splash.style.minWidth = "100%";
    all_background_splash.style.minHeight = "100%";
    all_background_splash.style.zIndex = "900";

    if (localStorage.getItem("theme") == "light") {all_background_splash.style.backgroundColor = "#eff5f5";}
    else {all_background_splash.style.backgroundColor = "#000000";}

    document.body.appendChild(all_background_splash);

    var splash_object = document.createElement("div");
    splash_object.className = "betteridu_splash";
    
    let screen_width = window.outerWidth;
    let screen_height = window.outerHeight;
    
    splash_object.style.position = "fixed";
    splash_object.style.overflow = "hidden";
    splash_object.style.opacity = "1";
    splash_object.style.top = "0";
    splash_object.style.left = "0";
    splash_object.style.width = `${screen_width}px`;
    splash_object.style.height = `${screen_height}px`;
    
    if (localStorage.getItem("theme") == "light") {splash_object.style.backgroundColor = "#eff5f5";}
    else {splash_object.style.backgroundColor = "#000000";}
    
    splash_object.style.zIndex = "1000";
    
    splash_object.style.display = "flex";
    splash_object.style.justifyContent = "center";
    splash_object.style.alignItems = "center";
    
    var splash_image = document.createElement("img");

    if (localStorage.getItem("theme") == "light") {splash_image.src = APP_PATH + "src/brand/small_text_logo_black_beta.png";}
    else { splash_image.src = APP_PATH + "src/brand/small_text_logo_white_beta.png"; }

    splash_image.style.width = `${screen_width / 2}px`;

    splash_image.style.objectFit = "contain";
    splash_image.style.maxWidth = "300px";

    splash_image.style.zIndex = "1100";

    splash_object.appendChild(splash_image);
    document.body.appendChild(splash_object);

    document.body.addEventListener("resize", update_betteridu_splash_size);
}

function show_betteridu_splash()
{
    if (document.body == null) {setTimeout(show_betteridu_splash, 1); return;}

    if (document.querySelector(".betteridu_splash") != null) { document.querySelector(".betteridu_splash").style.display = "flex"; }
    else {create_betteridu_splash();}
}

function hide_betteridu_splash()
{
    if (document.querySelector(".betteridu_splash") != null)
    {
        document.querySelector(".betteridu_splash").style.transitionDuration = "400ms"
        document.querySelector(".betteridu_splash > img").style.transitionDuration = "400ms"

        setTimeout(function()
        {            
            document.querySelector(".betteridu_splash").style.opacity = "0";
            document.querySelector(".betteridu_splash > img").style.opacity = "0";
        }, 200);

        setTimeout(function() {document.querySelector(".betteridu_splash").remove()}, 600);
        document.querySelector(".betteridu_splash_all_background").remove();
    }
}

show_betteridu_splash()

setTimeout(hide_betteridu_splash, 2000);