function fetch_fancybox()
{
    if (document.querySelector("#fancybox-tmp") == null || document.querySelector("#fancybox-tmp").innerHTML == "") {
        setTimeout(fetch_fancybox, 10);
        return;
    }

    console.log("Fancybox found!")

    document.querySelector("#fancybox-tmp").style.padding = "0px";

    
    document.querySelector("#fancybox-tmp").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
}

function fix_fancybox_buttons()
{
    fancybox_buttons = document.querySelectorAll("a.fancybox")
    Array.from(fancybox_buttons).forEach(button => {
        button.addEventListener("click", function(e) {
            // scroll to bottom of page
            console.log("Searching for fancybox..")
            fetch_fancybox()
        })
    })
}

function hide_top_panel()
{
    document.querySelector("#top-selection").style.display = "none"
    document.querySelector("#breadcrumbs-section").style.display = "none"
    document.querySelector("#top").style.display = "none"
}

function update_logined_in_style()
{
    load_style(APP_PATH + "styles/input_fields.css")
    hide_top_panel()
    fix_fancybox_buttons()
}

function try_updating_logined_in_style()
{
    if (document.readyState === "complete") {
        update_logined_in_style()
        return true
    }

    return false
}

if (!try_updating_logined_in_style()) {
    let style_updating_interval = setInterval(function() { if (try_updating_logined_in_style()) { clearInterval(style_updating_interval); }}, 10);
}